/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RespondToAuthChallengeRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> CHALLENGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChallengeName").isBinary(false).build();
    private static final MarshallingInfo<String> SESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Session").isBinary(false).build();
    private static final MarshallingInfo<Map> CHALLENGERESPONSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChallengeResponses").isBinary(false).build();
    private static final RespondToAuthChallengeRequestModelMarshaller INSTANCE = new RespondToAuthChallengeRequestModelMarshaller();

    private RespondToAuthChallengeRequestModelMarshaller() {
    }

    public static RespondToAuthChallengeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RespondToAuthChallengeRequest respondToAuthChallengeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)respondToAuthChallengeRequest), (String)"respondToAuthChallengeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)respondToAuthChallengeRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)respondToAuthChallengeRequest.challengeNameAsString(), CHALLENGENAME_BINDING);
            protocolMarshaller.marshall((Object)respondToAuthChallengeRequest.session(), SESSION_BINDING);
            protocolMarshaller.marshall(respondToAuthChallengeRequest.challengeResponses(), CHALLENGERESPONSES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

