/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceServerTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Identifier").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> SCOPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Scopes").isBinary(false).build();
    private static final ResourceServerTypeMarshaller INSTANCE = new ResourceServerTypeMarshaller();

    private ResourceServerTypeMarshaller() {
    }

    public static ResourceServerTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceServerType resourceServerType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceServerType, (String)"resourceServerType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceServerType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)resourceServerType.identifier(), IDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)resourceServerType.name(), NAME_BINDING);
            protocolMarshaller.marshall(resourceServerType.scopes(), SCOPES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

