/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResendConfirmationCodeRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretHash").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final ResendConfirmationCodeRequestModelMarshaller INSTANCE = new ResendConfirmationCodeRequestModelMarshaller();

    private ResendConfirmationCodeRequestModelMarshaller() {
    }

    public static ResendConfirmationCodeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResendConfirmationCodeRequest resendConfirmationCodeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)resendConfirmationCodeRequest), (String)"resendConfirmationCodeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resendConfirmationCodeRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)resendConfirmationCodeRequest.secretHash(), SECRETHASH_BINDING);
            protocolMarshaller.marshall((Object)resendConfirmationCodeRequest.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

