/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MFAOptionTypeMarshaller {
    private static final MarshallingInfo<String> DELIVERYMEDIUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryMedium").isBinary(false).build();
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").isBinary(false).build();
    private static final MFAOptionTypeMarshaller INSTANCE = new MFAOptionTypeMarshaller();

    private MFAOptionTypeMarshaller() {
    }

    public static MFAOptionTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MFAOptionType mfaOptionType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mfaOptionType, (String)"mfaOptionType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mfaOptionType.deliveryMediumAsString(), DELIVERYMEDIUM_BINDING);
            protocolMarshaller.marshall((Object)mfaOptionType.attributeName(), ATTRIBUTENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

