/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LambdaConfigTypeMarshaller {
    private static final MarshallingInfo<String> PRESIGNUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreSignUp").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomMessage").isBinary(false).build();
    private static final MarshallingInfo<String> POSTCONFIRMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostConfirmation").isBinary(false).build();
    private static final MarshallingInfo<String> PREAUTHENTICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreAuthentication").isBinary(false).build();
    private static final MarshallingInfo<String> POSTAUTHENTICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostAuthentication").isBinary(false).build();
    private static final MarshallingInfo<String> DEFINEAUTHCHALLENGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefineAuthChallenge").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEAUTHCHALLENGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateAuthChallenge").isBinary(false).build();
    private static final MarshallingInfo<String> VERIFYAUTHCHALLENGERESPONSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VerifyAuthChallengeResponse").isBinary(false).build();
    private static final LambdaConfigTypeMarshaller INSTANCE = new LambdaConfigTypeMarshaller();

    private LambdaConfigTypeMarshaller() {
    }

    public static LambdaConfigTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LambdaConfigType lambdaConfigType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lambdaConfigType, (String)"lambdaConfigType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lambdaConfigType.preSignUp(), PRESIGNUP_BINDING);
            protocolMarshaller.marshall((Object)lambdaConfigType.customMessage(), CUSTOMMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)lambdaConfigType.postConfirmation(), POSTCONFIRMATION_BINDING);
            protocolMarshaller.marshall((Object)lambdaConfigType.preAuthentication(), PREAUTHENTICATION_BINDING);
            protocolMarshaller.marshall((Object)lambdaConfigType.postAuthentication(), POSTAUTHENTICATION_BINDING);
            protocolMarshaller.marshall((Object)lambdaConfigType.defineAuthChallenge(), DEFINEAUTHCHALLENGE_BINDING);
            protocolMarshaller.marshall((Object)lambdaConfigType.createAuthChallenge(), CREATEAUTHCHALLENGE_BINDING);
            protocolMarshaller.marshall((Object)lambdaConfigType.verifyAuthChallengeResponse(), VERIFYAUTHCHALLENGERESPONSE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

