/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType;

public class GroupTypeUnmarshaller
implements Unmarshaller<GroupType, JsonUnmarshallerContext> {
    private static final GroupTypeUnmarshaller INSTANCE = new GroupTypeUnmarshaller();

    public GroupType unmarshall(JsonUnmarshallerContext context) throws Exception {
        GroupType.Builder groupTypeBuilder = GroupType.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("GroupName", targetDepth)) {
                    context.nextToken();
                    groupTypeBuilder.groupName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("UserPoolId", targetDepth)) {
                    context.nextToken();
                    groupTypeBuilder.userPoolId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    groupTypeBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    groupTypeBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Precedence", targetDepth)) {
                    context.nextToken();
                    groupTypeBuilder.precedence((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    groupTypeBuilder.lastModifiedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    groupTypeBuilder.creationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GroupType)groupTypeBuilder.build();
    }

    public static GroupTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

