/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ForgetDeviceRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceKey").isBinary(false).build();
    private static final ForgetDeviceRequestModelMarshaller INSTANCE = new ForgetDeviceRequestModelMarshaller();

    private ForgetDeviceRequestModelMarshaller() {
    }

    public static ForgetDeviceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ForgetDeviceRequest forgetDeviceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)forgetDeviceRequest), (String)"forgetDeviceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)forgetDeviceRequest.accessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall((Object)forgetDeviceRequest.deviceKey(), DEVICEKEY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

