/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EmailConfigurationTypeMarshaller {
    private static final MarshallingInfo<String> SOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceArn").isBinary(false).build();
    private static final MarshallingInfo<String> REPLYTOEMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplyToEmailAddress").isBinary(false).build();
    private static final EmailConfigurationTypeMarshaller INSTANCE = new EmailConfigurationTypeMarshaller();

    private EmailConfigurationTypeMarshaller() {
    }

    public static EmailConfigurationTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EmailConfigurationType emailConfigurationType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)emailConfigurationType, (String)"emailConfigurationType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)emailConfigurationType.sourceArn(), SOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)emailConfigurationType.replyToEmailAddress(), REPLYTOEMAILADDRESS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

