/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceTypeMarshaller {
    private static final MarshallingInfo<String> DEVICEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceKey").isBinary(false).build();
    private static final MarshallingInfo<List> DEVICEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceAttributes").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEVICECREATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceCreateDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEVICELASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEVICELASTAUTHENTICATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastAuthenticatedDate").isBinary(false).build();
    private static final DeviceTypeMarshaller INSTANCE = new DeviceTypeMarshaller();

    private DeviceTypeMarshaller() {
    }

    public static DeviceTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceType deviceType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceType, (String)"deviceType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deviceType.deviceKey(), DEVICEKEY_BINDING);
            protocolMarshaller.marshall(deviceType.deviceAttributes(), DEVICEATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)deviceType.deviceCreateDate(), DEVICECREATEDATE_BINDING);
            protocolMarshaller.marshall((Object)deviceType.deviceLastModifiedDate(), DEVICELASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)deviceType.deviceLastAuthenticatedDate(), DEVICELASTAUTHENTICATEDDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

