/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateGroupRequestModelMarshaller {
    private static final MarshallingInfo<String> GROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupName").isBinary(false).build();
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> PRECEDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Precedence").isBinary(false).build();
    private static final CreateGroupRequestModelMarshaller INSTANCE = new CreateGroupRequestModelMarshaller();

    private CreateGroupRequestModelMarshaller() {
    }

    public static CreateGroupRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateGroupRequest createGroupRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createGroupRequest), (String)"createGroupRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createGroupRequest.groupName(), GROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)createGroupRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)createGroupRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createGroupRequest.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createGroupRequest.precedence(), PRECEDENCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

