/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfirmDeviceRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceKey").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICESECRETVERIFIERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceSecretVerifierConfig").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").isBinary(false).build();
    private static final ConfirmDeviceRequestModelMarshaller INSTANCE = new ConfirmDeviceRequestModelMarshaller();

    private ConfirmDeviceRequestModelMarshaller() {
    }

    public static ConfirmDeviceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfirmDeviceRequest confirmDeviceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)confirmDeviceRequest), (String)"confirmDeviceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)confirmDeviceRequest.accessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall((Object)confirmDeviceRequest.deviceKey(), DEVICEKEY_BINDING);
            protocolMarshaller.marshall((Object)confirmDeviceRequest.deviceSecretVerifierConfig(), DEVICESECRETVERIFIERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)confirmDeviceRequest.deviceName(), DEVICENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

