/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AdminUpdateUserAttributesRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<List> USERATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserAttributes").isBinary(false).build();
    private static final AdminUpdateUserAttributesRequestModelMarshaller INSTANCE = new AdminUpdateUserAttributesRequestModelMarshaller();

    private AdminUpdateUserAttributesRequestModelMarshaller() {
    }

    public static AdminUpdateUserAttributesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)adminUpdateUserAttributesRequest), (String)"adminUpdateUserAttributesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)adminUpdateUserAttributesRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)adminUpdateUserAttributesRequest.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(adminUpdateUserAttributesRequest.userAttributes(), USERATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

