/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserAttributesResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, UpdateUserAttributesResponse> {
    private final List<CodeDeliveryDetailsType> codeDeliveryDetailsList;

    private UpdateUserAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.codeDeliveryDetailsList = builder.codeDeliveryDetailsList;
    }

    public List<CodeDeliveryDetailsType> codeDeliveryDetailsList() {
        return this.codeDeliveryDetailsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeliveryDetailsList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAttributesResponse)) {
            return false;
        }
        UpdateUserAttributesResponse other = (UpdateUserAttributesResponse)((Object)obj);
        return Objects.equals(this.codeDeliveryDetailsList(), other.codeDeliveryDetailsList());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserAttributesResponse").add("CodeDeliveryDetailsList", this.codeDeliveryDetailsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeDeliveryDetailsList": {
                return Optional.ofNullable(clazz.cast(this.codeDeliveryDetailsList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<CodeDeliveryDetailsType> codeDeliveryDetailsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserAttributesResponse model) {
            super(model);
            this.codeDeliveryDetailsList(model.codeDeliveryDetailsList);
        }

        public final Collection<CodeDeliveryDetailsType.Builder> getCodeDeliveryDetailsList() {
            return this.codeDeliveryDetailsList != null ? (Collection)this.codeDeliveryDetailsList.stream().map(CodeDeliveryDetailsType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder codeDeliveryDetailsList(Collection<CodeDeliveryDetailsType> codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList = CodeDeliveryDetailsListTypeCopier.copy(codeDeliveryDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeDeliveryDetailsList(CodeDeliveryDetailsType ... codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList(Arrays.asList(codeDeliveryDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeDeliveryDetailsList(Consumer<CodeDeliveryDetailsType.Builder> ... codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList(Stream.of(codeDeliveryDetailsList).map(c -> (CodeDeliveryDetailsType)((CodeDeliveryDetailsType.Builder)CodeDeliveryDetailsType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCodeDeliveryDetailsList(Collection<CodeDeliveryDetailsType.BuilderImpl> codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList = CodeDeliveryDetailsListTypeCopier.copyFromBuilder(codeDeliveryDetailsList);
        }

        @Override
        public UpdateUserAttributesResponse build() {
            return new UpdateUserAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, UpdateUserAttributesResponse> {
        public Builder codeDeliveryDetailsList(Collection<CodeDeliveryDetailsType> var1);

        public Builder codeDeliveryDetailsList(CodeDeliveryDetailsType ... var1);

        public Builder codeDeliveryDetailsList(Consumer<CodeDeliveryDetailsType.Builder> ... var1);
    }
}

