/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SmsConfigurationTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SmsConfigurationType
implements StructuredPojo,
ToCopyableBuilder<Builder, SmsConfigurationType> {
    private final String snsCallerArn;
    private final String externalId;

    private SmsConfigurationType(BuilderImpl builder) {
        this.snsCallerArn = builder.snsCallerArn;
        this.externalId = builder.externalId;
    }

    public String snsCallerArn() {
        return this.snsCallerArn;
    }

    public String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsCallerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsConfigurationType)) {
            return false;
        }
        SmsConfigurationType other = (SmsConfigurationType)obj;
        return Objects.equals(this.snsCallerArn(), other.snsCallerArn()) && Objects.equals(this.externalId(), other.externalId());
    }

    public String toString() {
        return ToString.builder((String)"SmsConfigurationType").add("SnsCallerArn", (Object)this.snsCallerArn()).add("ExternalId", (Object)this.externalId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnsCallerArn": {
                return Optional.ofNullable(clazz.cast(this.snsCallerArn()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SmsConfigurationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String snsCallerArn;
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsConfigurationType model) {
            this.snsCallerArn(model.snsCallerArn);
            this.externalId(model.externalId);
        }

        public final String getSnsCallerArn() {
            return this.snsCallerArn;
        }

        @Override
        public final Builder snsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
            return this;
        }

        public final void setSnsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public SmsConfigurationType build() {
            return new SmsConfigurationType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SmsConfigurationType> {
        public Builder snsCallerArn(String var1);

        public Builder externalId(String var1);
    }
}

