/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignUpResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, SignUpResponse> {
    private final Boolean userConfirmed;
    private final CodeDeliveryDetailsType codeDeliveryDetails;
    private final String userSub;

    private SignUpResponse(BuilderImpl builder) {
        super(builder);
        this.userConfirmed = builder.userConfirmed;
        this.codeDeliveryDetails = builder.codeDeliveryDetails;
        this.userSub = builder.userSub;
    }

    public Boolean userConfirmed() {
        return this.userConfirmed;
    }

    public CodeDeliveryDetailsType codeDeliveryDetails() {
        return this.codeDeliveryDetails;
    }

    public String userSub() {
        return this.userSub;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userConfirmed());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeliveryDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSub());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignUpResponse)) {
            return false;
        }
        SignUpResponse other = (SignUpResponse)((Object)obj);
        return Objects.equals(this.userConfirmed(), other.userConfirmed()) && Objects.equals(this.codeDeliveryDetails(), other.codeDeliveryDetails()) && Objects.equals(this.userSub(), other.userSub());
    }

    public String toString() {
        return ToString.builder((String)"SignUpResponse").add("UserConfirmed", (Object)this.userConfirmed()).add("CodeDeliveryDetails", (Object)this.codeDeliveryDetails()).add("UserSub", (Object)this.userSub()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserConfirmed": {
                return Optional.ofNullable(clazz.cast(this.userConfirmed()));
            }
            case "CodeDeliveryDetails": {
                return Optional.ofNullable(clazz.cast(this.codeDeliveryDetails()));
            }
            case "UserSub": {
                return Optional.ofNullable(clazz.cast(this.userSub()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private Boolean userConfirmed;
        private CodeDeliveryDetailsType codeDeliveryDetails;
        private String userSub;

        private BuilderImpl() {
        }

        private BuilderImpl(SignUpResponse model) {
            super(model);
            this.userConfirmed(model.userConfirmed);
            this.codeDeliveryDetails(model.codeDeliveryDetails);
            this.userSub(model.userSub);
        }

        public final Boolean getUserConfirmed() {
            return this.userConfirmed;
        }

        @Override
        public final Builder userConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
            return this;
        }

        public final void setUserConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
        }

        public final CodeDeliveryDetailsType.Builder getCodeDeliveryDetails() {
            return this.codeDeliveryDetails != null ? this.codeDeliveryDetails.toBuilder() : null;
        }

        @Override
        public final Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails;
            return this;
        }

        public final void setCodeDeliveryDetails(CodeDeliveryDetailsType.BuilderImpl codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails != null ? codeDeliveryDetails.build() : null;
        }

        public final String getUserSub() {
            return this.userSub;
        }

        @Override
        public final Builder userSub(String userSub) {
            this.userSub = userSub;
            return this;
        }

        public final void setUserSub(String userSub) {
            this.userSub = userSub;
        }

        @Override
        public SignUpResponse build() {
            return new SignUpResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, SignUpResponse> {
        public Builder userConfirmed(Boolean var1);

        public Builder codeDeliveryDetails(CodeDeliveryDetailsType var1);

        default public Builder codeDeliveryDetails(Consumer<CodeDeliveryDetailsType.Builder> codeDeliveryDetails) {
            return this.codeDeliveryDetails((CodeDeliveryDetailsType)((CodeDeliveryDetailsType.Builder)CodeDeliveryDetailsType.builder().applyMutation(codeDeliveryDetails)).build());
        }

        public Builder userSub(String var1);
    }
}

