/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetUiCustomizationRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, SetUiCustomizationRequest> {
    private final String userPoolId;
    private final String clientId;
    private final String css;
    private final SdkBytes imageFile;

    private SetUiCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.css = builder.css;
        this.imageFile = builder.imageFile;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String css() {
        return this.css;
    }

    public SdkBytes imageFile() {
        return this.imageFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.css());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageFile());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUiCustomizationRequest)) {
            return false;
        }
        SetUiCustomizationRequest other = (SetUiCustomizationRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.css(), other.css()) && Objects.equals(this.imageFile(), other.imageFile());
    }

    public String toString() {
        return ToString.builder((String)"SetUiCustomizationRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)this.clientId()).add("CSS", (Object)this.css()).add("ImageFile", (Object)this.imageFile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "CSS": {
                return Optional.ofNullable(clazz.cast(this.css()));
            }
            case "ImageFile": {
                return Optional.ofNullable(clazz.cast(this.imageFile()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private String css;
        private SdkBytes imageFile;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUiCustomizationRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.css(model.css);
            this.imageFile(model.imageFile);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getCSS() {
            return this.css;
        }

        @Override
        public final Builder css(String css) {
            this.css = css;
            return this;
        }

        public final void setCSS(String css) {
            this.css = css;
        }

        public final ByteBuffer getImageFile() {
            return this.imageFile == null ? null : this.imageFile.asByteBuffer();
        }

        @Override
        public final Builder imageFile(SdkBytes imageFile) {
            this.imageFile = StandardMemberCopier.copy((SdkBytes)imageFile);
            return this;
        }

        public final void setImageFile(ByteBuffer imageFile) {
            this.imageFile(imageFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)imageFile));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUiCustomizationRequest build() {
            return new SetUiCustomizationRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, SetUiCustomizationRequest> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder css(String var1);

        public Builder imageFile(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

