/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponsesTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RespondToAuthChallengeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, RespondToAuthChallengeRequest> {
    private final String clientId;
    private final String challengeName;
    private final String session;
    private final Map<String, String> challengeResponses;

    private RespondToAuthChallengeRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.challengeName = builder.challengeName;
        this.session = builder.session;
        this.challengeResponses = builder.challengeResponses;
    }

    public String clientId() {
        return this.clientId;
    }

    public ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(this.challengeName);
    }

    public String challengeNameAsString() {
        return this.challengeName;
    }

    public String session() {
        return this.session;
    }

    public Map<String, String> challengeResponses() {
        return this.challengeResponses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeResponses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondToAuthChallengeRequest)) {
            return false;
        }
        RespondToAuthChallengeRequest other = (RespondToAuthChallengeRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.challengeResponses(), other.challengeResponses());
    }

    public String toString() {
        return ToString.builder((String)"RespondToAuthChallengeRequest").add("ClientId", (Object)this.clientId()).add("ChallengeName", (Object)this.challengeNameAsString()).add("Session", (Object)this.session()).add("ChallengeResponses", this.challengeResponses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "ChallengeResponses": {
                return Optional.ofNullable(clazz.cast(this.challengeResponses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String challengeName;
        private String session;
        private Map<String, String> challengeResponses = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RespondToAuthChallengeRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.challengeName(model.challengeName);
            this.session(model.session);
            this.challengeResponses(model.challengeResponses);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName.toString());
            return this;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        public final String getSession() {
            return this.session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        public final Map<String, String> getChallengeResponses() {
            return this.challengeResponses;
        }

        @Override
        public final Builder challengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
            return this;
        }

        public final void setChallengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RespondToAuthChallengeRequest build() {
            return new RespondToAuthChallengeRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, RespondToAuthChallengeRequest> {
        public Builder clientId(String var1);

        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeNameType var1);

        public Builder session(String var1);

        public Builder challengeResponses(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

