/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.MessageTemplateTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateType
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageTemplateType> {
    private final String smsMessage;
    private final String emailMessage;
    private final String emailSubject;

    private MessageTemplateType(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
    }

    public String smsMessage() {
        return this.smsMessage;
    }

    public String emailMessage() {
        return this.emailMessage;
    }

    public String emailSubject() {
        return this.emailSubject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSubject());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateType)) {
            return false;
        }
        MessageTemplateType other = (MessageTemplateType)obj;
        return Objects.equals(this.smsMessage(), other.smsMessage()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.emailSubject(), other.emailSubject());
    }

    public String toString() {
        return ToString.builder((String)"MessageTemplateType").add("SMSMessage", (Object)this.smsMessage()).add("EmailMessage", (Object)this.emailMessage()).add("EmailSubject", (Object)this.emailSubject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SMSMessage": {
                return Optional.ofNullable(clazz.cast(this.smsMessage()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "EmailSubject": {
                return Optional.ofNullable(clazz.cast(this.emailSubject()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageTemplateTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String smsMessage;
        private String emailMessage;
        private String emailSubject;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateType model) {
            this.smsMessage(model.smsMessage);
            this.emailMessage(model.emailMessage);
            this.emailSubject(model.emailSubject);
        }

        public final String getSMSMessage() {
            return this.smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSMSMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        public final String getEmailSubject() {
            return this.emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        public MessageTemplateType build() {
            return new MessageTemplateType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageTemplateType> {
        public Builder smsMessage(String var1);

        public Builder emailMessage(String var1);

        public Builder emailSubject(String var1);
    }
}

