/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SearchedAttributeNamesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ListUsersRequest> {
    private final String userPoolId;
    private final List<String> attributesToGet;
    private final Integer limit;
    private final String paginationToken;
    private final String filter;

    private ListUsersRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.paginationToken = builder.paginationToken;
        this.filter = builder.filter;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Integer limit() {
        return this.limit;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    public String filter() {
        return this.filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest other = (ListUsersRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.paginationToken(), other.paginationToken()) && Objects.equals(this.filter(), other.filter());
    }

    public String toString() {
        return ToString.builder((String)"ListUsersRequest").add("UserPoolId", (Object)this.userPoolId()).add("AttributesToGet", this.attributesToGet()).add("Limit", (Object)this.limit()).add("PaginationToken", (Object)this.paginationToken()).add("Filter", (Object)this.filter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "AttributesToGet": {
                return Optional.ofNullable(clazz.cast(this.attributesToGet()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String paginationToken;
        private String filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.attributesToGet(model.attributesToGet);
            this.limit(model.limit);
            this.paginationToken(model.paginationToken);
            this.filter(model.filter);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = SearchedAttributeNamesListTypeCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = SearchedAttributeNamesListTypeCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        public final String getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListUsersRequest build() {
            return new ListUsersRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, ListUsersRequest> {
        public Builder userPoolId(String var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder limit(Integer var1);

        public Builder paginationToken(String var1);

        public Builder filter(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

