/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeviceTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceType
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceType> {
    private final String deviceKey;
    private final List<AttributeType> deviceAttributes;
    private final Instant deviceCreateDate;
    private final Instant deviceLastModifiedDate;
    private final Instant deviceLastAuthenticatedDate;

    private DeviceType(BuilderImpl builder) {
        this.deviceKey = builder.deviceKey;
        this.deviceAttributes = builder.deviceAttributes;
        this.deviceCreateDate = builder.deviceCreateDate;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
        this.deviceLastAuthenticatedDate = builder.deviceLastAuthenticatedDate;
    }

    public String deviceKey() {
        return this.deviceKey;
    }

    public List<AttributeType> deviceAttributes() {
        return this.deviceAttributes;
    }

    public Instant deviceCreateDate() {
        return this.deviceCreateDate;
    }

    public Instant deviceLastModifiedDate() {
        return this.deviceLastModifiedDate;
    }

    public Instant deviceLastAuthenticatedDate() {
        return this.deviceLastAuthenticatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceLastAuthenticatedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceType)) {
            return false;
        }
        DeviceType other = (DeviceType)obj;
        return Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.deviceAttributes(), other.deviceAttributes()) && Objects.equals(this.deviceCreateDate(), other.deviceCreateDate()) && Objects.equals(this.deviceLastModifiedDate(), other.deviceLastModifiedDate()) && Objects.equals(this.deviceLastAuthenticatedDate(), other.deviceLastAuthenticatedDate());
    }

    public String toString() {
        return ToString.builder((String)"DeviceType").add("DeviceKey", (Object)this.deviceKey()).add("DeviceAttributes", this.deviceAttributes()).add("DeviceCreateDate", (Object)this.deviceCreateDate()).add("DeviceLastModifiedDate", (Object)this.deviceLastModifiedDate()).add("DeviceLastAuthenticatedDate", (Object)this.deviceLastAuthenticatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "DeviceAttributes": {
                return Optional.ofNullable(clazz.cast(this.deviceAttributes()));
            }
            case "DeviceCreateDate": {
                return Optional.ofNullable(clazz.cast(this.deviceCreateDate()));
            }
            case "DeviceLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.deviceLastModifiedDate()));
            }
            case "DeviceLastAuthenticatedDate": {
                return Optional.ofNullable(clazz.cast(this.deviceLastAuthenticatedDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceKey;
        private List<AttributeType> deviceAttributes = DefaultSdkAutoConstructList.getInstance();
        private Instant deviceCreateDate;
        private Instant deviceLastModifiedDate;
        private Instant deviceLastAuthenticatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceType model) {
            this.deviceKey(model.deviceKey);
            this.deviceAttributes(model.deviceAttributes);
            this.deviceCreateDate(model.deviceCreateDate);
            this.deviceLastModifiedDate(model.deviceLastModifiedDate);
            this.deviceLastAuthenticatedDate(model.deviceLastAuthenticatedDate);
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final Collection<AttributeType.Builder> getDeviceAttributes() {
            return this.deviceAttributes != null ? (Collection)this.deviceAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceAttributes(Collection<AttributeType> deviceAttributes) {
            this.deviceAttributes = AttributeListTypeCopier.copy(deviceAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceAttributes(AttributeType ... deviceAttributes) {
            this.deviceAttributes(Arrays.asList(deviceAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceAttributes(Consumer<AttributeType.Builder> ... deviceAttributes) {
            this.deviceAttributes(Stream.of(deviceAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceAttributes(Collection<AttributeType.BuilderImpl> deviceAttributes) {
            this.deviceAttributes = AttributeListTypeCopier.copyFromBuilder(deviceAttributes);
        }

        public final Instant getDeviceCreateDate() {
            return this.deviceCreateDate;
        }

        @Override
        public final Builder deviceCreateDate(Instant deviceCreateDate) {
            this.deviceCreateDate = deviceCreateDate;
            return this;
        }

        public final void setDeviceCreateDate(Instant deviceCreateDate) {
            this.deviceCreateDate = deviceCreateDate;
        }

        public final Instant getDeviceLastModifiedDate() {
            return this.deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        public final Instant getDeviceLastAuthenticatedDate() {
            return this.deviceLastAuthenticatedDate;
        }

        @Override
        public final Builder deviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate) {
            this.deviceLastAuthenticatedDate = deviceLastAuthenticatedDate;
            return this;
        }

        public final void setDeviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate) {
            this.deviceLastAuthenticatedDate = deviceLastAuthenticatedDate;
        }

        public DeviceType build() {
            return new DeviceType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceType> {
        public Builder deviceKey(String var1);

        public Builder deviceAttributes(Collection<AttributeType> var1);

        public Builder deviceAttributes(AttributeType ... var1);

        public Builder deviceAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder deviceCreateDate(Instant var1);

        public Builder deviceLastModifiedDate(Instant var1);

        public Builder deviceLastAuthenticatedDate(Instant var1);
    }
}

