/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeviceSecretVerifierConfigTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceSecretVerifierConfigType
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceSecretVerifierConfigType> {
    private final String passwordVerifier;
    private final String salt;

    private DeviceSecretVerifierConfigType(BuilderImpl builder) {
        this.passwordVerifier = builder.passwordVerifier;
        this.salt = builder.salt;
    }

    public String passwordVerifier() {
        return this.passwordVerifier;
    }

    public String salt() {
        return this.salt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordVerifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.salt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSecretVerifierConfigType)) {
            return false;
        }
        DeviceSecretVerifierConfigType other = (DeviceSecretVerifierConfigType)obj;
        return Objects.equals(this.passwordVerifier(), other.passwordVerifier()) && Objects.equals(this.salt(), other.salt());
    }

    public String toString() {
        return ToString.builder((String)"DeviceSecretVerifierConfigType").add("PasswordVerifier", (Object)this.passwordVerifier()).add("Salt", (Object)this.salt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PasswordVerifier": {
                return Optional.ofNullable(clazz.cast(this.passwordVerifier()));
            }
            case "Salt": {
                return Optional.ofNullable(clazz.cast(this.salt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceSecretVerifierConfigTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String passwordVerifier;
        private String salt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSecretVerifierConfigType model) {
            this.passwordVerifier(model.passwordVerifier);
            this.salt(model.salt);
        }

        public final String getPasswordVerifier() {
            return this.passwordVerifier;
        }

        @Override
        public final Builder passwordVerifier(String passwordVerifier) {
            this.passwordVerifier = passwordVerifier;
            return this;
        }

        public final void setPasswordVerifier(String passwordVerifier) {
            this.passwordVerifier = passwordVerifier;
        }

        public final String getSalt() {
            return this.salt;
        }

        @Override
        public final Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public final void setSalt(String salt) {
            this.salt = salt;
        }

        public DeviceSecretVerifierConfigType build() {
            return new DeviceSecretVerifierConfigType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceSecretVerifierConfigType> {
        public Builder passwordVerifier(String var1);

        public Builder salt(String var1);
    }
}

