/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeviceConfigurationTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceConfigurationType
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceConfigurationType> {
    private final Boolean challengeRequiredOnNewDevice;
    private final Boolean deviceOnlyRememberedOnUserPrompt;

    private DeviceConfigurationType(BuilderImpl builder) {
        this.challengeRequiredOnNewDevice = builder.challengeRequiredOnNewDevice;
        this.deviceOnlyRememberedOnUserPrompt = builder.deviceOnlyRememberedOnUserPrompt;
    }

    public Boolean challengeRequiredOnNewDevice() {
        return this.challengeRequiredOnNewDevice;
    }

    public Boolean deviceOnlyRememberedOnUserPrompt() {
        return this.deviceOnlyRememberedOnUserPrompt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeRequiredOnNewDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceOnlyRememberedOnUserPrompt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceConfigurationType)) {
            return false;
        }
        DeviceConfigurationType other = (DeviceConfigurationType)obj;
        return Objects.equals(this.challengeRequiredOnNewDevice(), other.challengeRequiredOnNewDevice()) && Objects.equals(this.deviceOnlyRememberedOnUserPrompt(), other.deviceOnlyRememberedOnUserPrompt());
    }

    public String toString() {
        return ToString.builder((String)"DeviceConfigurationType").add("ChallengeRequiredOnNewDevice", (Object)this.challengeRequiredOnNewDevice()).add("DeviceOnlyRememberedOnUserPrompt", (Object)this.deviceOnlyRememberedOnUserPrompt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChallengeRequiredOnNewDevice": {
                return Optional.ofNullable(clazz.cast(this.challengeRequiredOnNewDevice()));
            }
            case "DeviceOnlyRememberedOnUserPrompt": {
                return Optional.ofNullable(clazz.cast(this.deviceOnlyRememberedOnUserPrompt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceConfigurationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean challengeRequiredOnNewDevice;
        private Boolean deviceOnlyRememberedOnUserPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceConfigurationType model) {
            this.challengeRequiredOnNewDevice(model.challengeRequiredOnNewDevice);
            this.deviceOnlyRememberedOnUserPrompt(model.deviceOnlyRememberedOnUserPrompt);
        }

        public final Boolean getChallengeRequiredOnNewDevice() {
            return this.challengeRequiredOnNewDevice;
        }

        @Override
        public final Builder challengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
            return this;
        }

        public final void setChallengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
        }

        public final Boolean getDeviceOnlyRememberedOnUserPrompt() {
            return this.deviceOnlyRememberedOnUserPrompt;
        }

        @Override
        public final Builder deviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
            return this;
        }

        public final void setDeviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
        }

        public DeviceConfigurationType build() {
            return new DeviceConfigurationType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceConfigurationType> {
        public Builder challengeRequiredOnNewDevice(Boolean var1);

        public Builder deviceOnlyRememberedOnUserPrompt(Boolean var1);
    }
}

