/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIdentityProviderRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, DescribeIdentityProviderRequest> {
    private final String userPoolId;
    private final String providerName;

    private DescribeIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.providerName = builder.providerName;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String providerName() {
        return this.providerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderRequest)) {
            return false;
        }
        DescribeIdentityProviderRequest other = (DescribeIdentityProviderRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.providerName(), other.providerName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIdentityProviderRequest").add("UserPoolId", (Object)this.userPoolId()).add("ProviderName", (Object)this.providerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.providerName(model.providerName);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIdentityProviderRequest build() {
            return new DescribeIdentityProviderRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, DescribeIdentityProviderRequest> {
        public Builder userPoolId(String var1);

        public Builder providerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

