/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangePasswordRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ChangePasswordRequest> {
    private final String previousPassword;
    private final String proposedPassword;
    private final String accessToken;

    private ChangePasswordRequest(BuilderImpl builder) {
        super(builder);
        this.previousPassword = builder.previousPassword;
        this.proposedPassword = builder.proposedPassword;
        this.accessToken = builder.accessToken;
    }

    public String previousPassword() {
        return this.previousPassword;
    }

    public String proposedPassword() {
        return this.proposedPassword;
    }

    public String accessToken() {
        return this.accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.previousPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangePasswordRequest)) {
            return false;
        }
        ChangePasswordRequest other = (ChangePasswordRequest)((Object)obj);
        return Objects.equals(this.previousPassword(), other.previousPassword()) && Objects.equals(this.proposedPassword(), other.proposedPassword()) && Objects.equals(this.accessToken(), other.accessToken());
    }

    public String toString() {
        return ToString.builder((String)"ChangePasswordRequest").add("PreviousPassword", (Object)this.previousPassword()).add("ProposedPassword", (Object)this.proposedPassword()).add("AccessToken", (Object)this.accessToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreviousPassword": {
                return Optional.ofNullable(clazz.cast(this.previousPassword()));
            }
            case "ProposedPassword": {
                return Optional.ofNullable(clazz.cast(this.proposedPassword()));
            }
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String previousPassword;
        private String proposedPassword;
        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangePasswordRequest model) {
            super(model);
            this.previousPassword(model.previousPassword);
            this.proposedPassword(model.proposedPassword);
            this.accessToken(model.accessToken);
        }

        public final String getPreviousPassword() {
            return this.previousPassword;
        }

        @Override
        public final Builder previousPassword(String previousPassword) {
            this.previousPassword = previousPassword;
            return this;
        }

        public final void setPreviousPassword(String previousPassword) {
            this.previousPassword = previousPassword;
        }

        public final String getProposedPassword() {
            return this.proposedPassword;
        }

        @Override
        public final Builder proposedPassword(String proposedPassword) {
            this.proposedPassword = proposedPassword;
            return this;
        }

        public final void setProposedPassword(String proposedPassword) {
            this.proposedPassword = proposedPassword;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangePasswordRequest build() {
            return new ChangePasswordRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, ChangePasswordRequest> {
        public Builder previousPassword(String var1);

        public Builder proposedPassword(String var1);

        public Builder accessToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

