/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminUpdateDeviceStatusRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminUpdateDeviceStatusRequest> {
    private final String userPoolId;
    private final String username;
    private final String deviceKey;
    private final String deviceRememberedStatus;

    private AdminUpdateDeviceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.deviceKey = builder.deviceKey;
        this.deviceRememberedStatus = builder.deviceRememberedStatus;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String username() {
        return this.username;
    }

    public String deviceKey() {
        return this.deviceKey;
    }

    public DeviceRememberedStatusType deviceRememberedStatus() {
        return DeviceRememberedStatusType.fromValue(this.deviceRememberedStatus);
    }

    public String deviceRememberedStatusAsString() {
        return this.deviceRememberedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRememberedStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminUpdateDeviceStatusRequest)) {
            return false;
        }
        AdminUpdateDeviceStatusRequest other = (AdminUpdateDeviceStatusRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.deviceRememberedStatusAsString(), other.deviceRememberedStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"AdminUpdateDeviceStatusRequest").add("UserPoolId", (Object)this.userPoolId()).add("Username", (Object)this.username()).add("DeviceKey", (Object)this.deviceKey()).add("DeviceRememberedStatus", (Object)this.deviceRememberedStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "DeviceRememberedStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceRememberedStatusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String username;
        private String deviceKey;
        private String deviceRememberedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminUpdateDeviceStatusRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.username(model.username);
            this.deviceKey(model.deviceKey);
            this.deviceRememberedStatus(model.deviceRememberedStatus);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final String getDeviceRememberedStatus() {
            return this.deviceRememberedStatus;
        }

        @Override
        public final Builder deviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
            return this;
        }

        @Override
        public final Builder deviceRememberedStatus(DeviceRememberedStatusType deviceRememberedStatus) {
            this.deviceRememberedStatus(deviceRememberedStatus.toString());
            return this;
        }

        public final void setDeviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminUpdateDeviceStatusRequest build() {
            return new AdminUpdateDeviceStatusRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, AdminUpdateDeviceStatusRequest> {
        public Builder userPoolId(String var1);

        public Builder username(String var1);

        public Builder deviceKey(String var1);

        public Builder deviceRememberedStatus(String var1);

        public Builder deviceRememberedStatus(DeviceRememberedStatusType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

