/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminListDevicesResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, AdminListDevicesResponse> {
    private final List<DeviceType> devices;
    private final String paginationToken;

    private AdminListDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
        this.paginationToken = builder.paginationToken;
    }

    public List<DeviceType> devices() {
        return this.devices;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devices());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminListDevicesResponse)) {
            return false;
        }
        AdminListDevicesResponse other = (AdminListDevicesResponse)((Object)obj);
        return Objects.equals(this.devices(), other.devices()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public String toString() {
        return ToString.builder((String)"AdminListDevicesResponse").add("Devices", this.devices()).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<DeviceType> devices = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminListDevicesResponse model) {
            super(model);
            this.devices(model.devices);
            this.paginationToken(model.paginationToken);
        }

        public final Collection<DeviceType.Builder> getDevices() {
            return this.devices != null ? (Collection)this.devices.stream().map(DeviceType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<DeviceType> devices) {
            this.devices = DeviceListTypeCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceType ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceType.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (DeviceType)((DeviceType.Builder)DeviceType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceType.BuilderImpl> devices) {
            this.devices = DeviceListTypeCopier.copyFromBuilder(devices);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public AdminListDevicesResponse build() {
            return new AdminListDevicesResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, AdminListDevicesResponse> {
        public Builder devices(Collection<DeviceType> var1);

        public Builder devices(DeviceType ... var1);

        public Builder devices(Consumer<DeviceType.Builder> ... var1);

        public Builder paginationToken(String var1);
    }
}

