/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminLinkProviderForUserRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminLinkProviderForUserRequest> {
    private final String userPoolId;
    private final ProviderUserIdentifierType destinationUser;
    private final ProviderUserIdentifierType sourceUser;

    private AdminLinkProviderForUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.destinationUser = builder.destinationUser;
        this.sourceUser = builder.sourceUser;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public ProviderUserIdentifierType destinationUser() {
        return this.destinationUser;
    }

    public ProviderUserIdentifierType sourceUser() {
        return this.sourceUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUser());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminLinkProviderForUserRequest)) {
            return false;
        }
        AdminLinkProviderForUserRequest other = (AdminLinkProviderForUserRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.destinationUser(), other.destinationUser()) && Objects.equals(this.sourceUser(), other.sourceUser());
    }

    public String toString() {
        return ToString.builder((String)"AdminLinkProviderForUserRequest").add("UserPoolId", (Object)this.userPoolId()).add("DestinationUser", (Object)this.destinationUser()).add("SourceUser", (Object)this.sourceUser()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "DestinationUser": {
                return Optional.ofNullable(clazz.cast(this.destinationUser()));
            }
            case "SourceUser": {
                return Optional.ofNullable(clazz.cast(this.sourceUser()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private ProviderUserIdentifierType destinationUser;
        private ProviderUserIdentifierType sourceUser;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminLinkProviderForUserRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.destinationUser(model.destinationUser);
            this.sourceUser(model.sourceUser);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final ProviderUserIdentifierType.Builder getDestinationUser() {
            return this.destinationUser != null ? this.destinationUser.toBuilder() : null;
        }

        @Override
        public final Builder destinationUser(ProviderUserIdentifierType destinationUser) {
            this.destinationUser = destinationUser;
            return this;
        }

        public final void setDestinationUser(ProviderUserIdentifierType.BuilderImpl destinationUser) {
            this.destinationUser = destinationUser != null ? destinationUser.build() : null;
        }

        public final ProviderUserIdentifierType.Builder getSourceUser() {
            return this.sourceUser != null ? this.sourceUser.toBuilder() : null;
        }

        @Override
        public final Builder sourceUser(ProviderUserIdentifierType sourceUser) {
            this.sourceUser = sourceUser;
            return this;
        }

        public final void setSourceUser(ProviderUserIdentifierType.BuilderImpl sourceUser) {
            this.sourceUser = sourceUser != null ? sourceUser.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminLinkProviderForUserRequest build() {
            return new AdminLinkProviderForUserRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, AdminLinkProviderForUserRequest> {
        public Builder userPoolId(String var1);

        public Builder destinationUser(ProviderUserIdentifierType var1);

        default public Builder destinationUser(Consumer<ProviderUserIdentifierType.Builder> destinationUser) {
            return this.destinationUser((ProviderUserIdentifierType)((ProviderUserIdentifierType.Builder)ProviderUserIdentifierType.builder().applyMutation(destinationUser)).build());
        }

        public Builder sourceUser(ProviderUserIdentifierType var1);

        default public Builder sourceUser(Consumer<ProviderUserIdentifierType.Builder> sourceUser) {
            return this.sourceUser((ProviderUserIdentifierType)((ProviderUserIdentifierType.Builder)ProviderUserIdentifierType.builder().applyMutation(sourceUser)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

