/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminGetUserResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, AdminGetUserResponse> {
    private final String username;
    private final List<AttributeType> userAttributes;
    private final Instant userCreateDate;
    private final Instant userLastModifiedDate;
    private final Boolean enabled;
    private final String userStatus;
    private final List<MFAOptionType> mfaOptions;

    private AdminGetUserResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.userCreateDate = builder.userCreateDate;
        this.userLastModifiedDate = builder.userLastModifiedDate;
        this.enabled = builder.enabled;
        this.userStatus = builder.userStatus;
        this.mfaOptions = builder.mfaOptions;
    }

    public String username() {
        return this.username;
    }

    public List<AttributeType> userAttributes() {
        return this.userAttributes;
    }

    public Instant userCreateDate() {
        return this.userCreateDate;
    }

    public Instant userLastModifiedDate() {
        return this.userLastModifiedDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public UserStatusType userStatus() {
        return UserStatusType.fromValue(this.userStatus);
    }

    public String userStatusAsString() {
        return this.userStatus;
    }

    public List<MFAOptionType> mfaOptions() {
        return this.mfaOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.userLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.userStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminGetUserResponse)) {
            return false;
        }
        AdminGetUserResponse other = (AdminGetUserResponse)((Object)obj);
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.userCreateDate(), other.userCreateDate()) && Objects.equals(this.userLastModifiedDate(), other.userLastModifiedDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.userStatusAsString(), other.userStatusAsString()) && Objects.equals(this.mfaOptions(), other.mfaOptions());
    }

    public String toString() {
        return ToString.builder((String)"AdminGetUserResponse").add("Username", (Object)this.username()).add("UserAttributes", this.userAttributes()).add("UserCreateDate", (Object)this.userCreateDate()).add("UserLastModifiedDate", (Object)this.userLastModifiedDate()).add("Enabled", (Object)this.enabled()).add("UserStatus", (Object)this.userStatusAsString()).add("MFAOptions", this.mfaOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "UserCreateDate": {
                return Optional.ofNullable(clazz.cast(this.userCreateDate()));
            }
            case "UserLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.userLastModifiedDate()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "UserStatus": {
                return Optional.ofNullable(clazz.cast(this.userStatusAsString()));
            }
            case "MFAOptions": {
                return Optional.ofNullable(clazz.cast(this.mfaOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String username;
        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private Instant userCreateDate;
        private Instant userLastModifiedDate;
        private Boolean enabled;
        private String userStatus;
        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminGetUserResponse model) {
            super(model);
            this.username(model.username);
            this.userAttributes(model.userAttributes);
            this.userCreateDate(model.userCreateDate);
            this.userLastModifiedDate(model.userLastModifiedDate);
            this.enabled(model.enabled);
            this.userStatus(model.userStatus);
            this.mfaOptions(model.mfaOptions);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            return this.userAttributes != null ? (Collection)this.userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final Instant getUserCreateDate() {
            return this.userCreateDate;
        }

        @Override
        public final Builder userCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
            return this;
        }

        public final void setUserCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
        }

        public final Instant getUserLastModifiedDate() {
            return this.userLastModifiedDate;
        }

        @Override
        public final Builder userLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
            return this;
        }

        public final void setUserLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getUserStatus() {
            return this.userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatusType userStatus) {
            this.userStatus(userStatus.toString());
            return this;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        public final Collection<MFAOptionType.Builder> getMFAOptions() {
            return this.mfaOptions != null ? (Collection)this.mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType ... mfaOptions) {
            this.mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder> ... mfaOptions) {
            this.mfaOptions(Stream.of(mfaOptions).map(c -> (MFAOptionType)((MFAOptionType.Builder)MFAOptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMFAOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        @Override
        public AdminGetUserResponse build() {
            return new AdminGetUserResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, AdminGetUserResponse> {
        public Builder username(String var1);

        public Builder userAttributes(Collection<AttributeType> var1);

        public Builder userAttributes(AttributeType ... var1);

        public Builder userAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder userCreateDate(Instant var1);

        public Builder userLastModifiedDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder userStatus(String var1);

        public Builder userStatus(UserStatusType var1);

        public Builder mfaOptions(Collection<MFAOptionType> var1);

        public Builder mfaOptions(MFAOptionType ... var1);

        public Builder mfaOptions(Consumer<MFAOptionType.Builder> ... var1);
    }
}

