/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeNameListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminDeleteUserAttributesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminDeleteUserAttributesRequest> {
    private final String userPoolId;
    private final String username;
    private final List<String> userAttributeNames;

    private AdminDeleteUserAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.userAttributeNames = builder.userAttributeNames;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String username() {
        return this.username;
    }

    public List<String> userAttributeNames() {
        return this.userAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminDeleteUserAttributesRequest)) {
            return false;
        }
        AdminDeleteUserAttributesRequest other = (AdminDeleteUserAttributesRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.userAttributeNames(), other.userAttributeNames());
    }

    public String toString() {
        return ToString.builder((String)"AdminDeleteUserAttributesRequest").add("UserPoolId", (Object)this.userPoolId()).add("Username", (Object)this.username()).add("UserAttributeNames", this.userAttributeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.userAttributeNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String username;
        private List<String> userAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminDeleteUserAttributesRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.username(model.username);
            this.userAttributeNames(model.userAttributeNames);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<String> getUserAttributeNames() {
            return this.userAttributeNames;
        }

        @Override
        public final Builder userAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributeNames(String ... userAttributeNames) {
            this.userAttributeNames(Arrays.asList(userAttributeNames));
            return this;
        }

        public final void setUserAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminDeleteUserAttributesRequest build() {
            return new AdminDeleteUserAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, AdminDeleteUserAttributesRequest> {
        public Builder userPoolId(String var1);

        public Builder username(String var1);

        public Builder userAttributeNames(Collection<String> var1);

        public Builder userAttributeNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

