/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CustomAttributesListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddCustomAttributesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AddCustomAttributesRequest> {
    private final String userPoolId;
    private final List<SchemaAttributeType> customAttributes;

    private AddCustomAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.customAttributes = builder.customAttributes;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public List<SchemaAttributeType> customAttributes() {
        return this.customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCustomAttributesRequest)) {
            return false;
        }
        AddCustomAttributesRequest other = (AddCustomAttributesRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.customAttributes(), other.customAttributes());
    }

    public String toString() {
        return ToString.builder((String)"AddCustomAttributesRequest").add("UserPoolId", (Object)this.userPoolId()).add("CustomAttributes", this.customAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private List<SchemaAttributeType> customAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddCustomAttributesRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.customAttributes(model.customAttributes);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final Collection<SchemaAttributeType.Builder> getCustomAttributes() {
            return this.customAttributes != null ? (Collection)this.customAttributes.stream().map(SchemaAttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customAttributes(Collection<SchemaAttributeType> customAttributes) {
            this.customAttributes = CustomAttributesListTypeCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(SchemaAttributeType ... customAttributes) {
            this.customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<SchemaAttributeType.Builder> ... customAttributes) {
            this.customAttributes(Stream.of(customAttributes).map(c -> (SchemaAttributeType)((SchemaAttributeType.Builder)SchemaAttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomAttributes(Collection<SchemaAttributeType.BuilderImpl> customAttributes) {
            this.customAttributes = CustomAttributesListTypeCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddCustomAttributesRequest build() {
            return new AddCustomAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, AddCustomAttributesRequest> {
        public Builder userPoolId(String var1);

        public Builder customAttributes(Collection<SchemaAttributeType> var1);

        public Builder customAttributes(SchemaAttributeType ... var1);

        public Builder customAttributes(Consumer<SchemaAttributeType.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

