/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UserPoolType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UserPoolTypeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> POLICIES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policies").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LAMBDACONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaConfig")
            .isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();

    private static final MarshallingInfo<List> SCHEMAATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> AUTOVERIFIEDATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoVerifiedAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> ALIASATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> USERNAMEATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UsernameAttributes").isBinary(false).build();

    private static final MarshallingInfo<String> SMSVERIFICATIONMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsVerificationMessage").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILVERIFICATIONMESSAGE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EmailVerificationMessage").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILVERIFICATIONSUBJECT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EmailVerificationSubject").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> VERIFICATIONMESSAGETEMPLATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("VerificationMessageTemplate").isBinary(false).build();

    private static final MarshallingInfo<String> SMSAUTHENTICATIONMESSAGE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SmsAuthenticationMessage").isBinary(false).build();

    private static final MarshallingInfo<String> MFACONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MfaConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DEVICECONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeviceConfiguration").isBinary(false).build();

    private static final MarshallingInfo<Integer> ESTIMATEDNUMBEROFUSERS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EstimatedNumberOfUsers").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EMAILCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EmailConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SMSCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SmsConfiguration").isBinary(false).build();

    private static final MarshallingInfo<Map> USERPOOLTAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolTags").isBinary(false).build();

    private static final MarshallingInfo<String> SMSCONFIGURATIONFAILURE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SmsConfigurationFailure").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILCONFIGURATIONFAILURE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EmailConfigurationFailure").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ADMINCREATEUSERCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AdminCreateUserConfig").isBinary(false).build();

    private static final UserPoolTypeMarshaller INSTANCE = new UserPoolTypeMarshaller();

    private UserPoolTypeMarshaller() {
    }

    public static UserPoolTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UserPoolType userPoolType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(userPoolType, "userPoolType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(userPoolType.id(), ID_BINDING);
            protocolMarshaller.marshall(userPoolType.name(), NAME_BINDING);
            protocolMarshaller.marshall(userPoolType.policies(), POLICIES_BINDING);
            protocolMarshaller.marshall(userPoolType.lambdaConfig(), LAMBDACONFIG_BINDING);
            protocolMarshaller.marshall(userPoolType.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(userPoolType.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall(userPoolType.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(userPoolType.schemaAttributes(), SCHEMAATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolType.autoVerifiedAttributesAsStrings(), AUTOVERIFIEDATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolType.aliasAttributesAsStrings(), ALIASATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolType.usernameAttributesAsStrings(), USERNAMEATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolType.smsVerificationMessage(), SMSVERIFICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall(userPoolType.emailVerificationMessage(), EMAILVERIFICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall(userPoolType.emailVerificationSubject(), EMAILVERIFICATIONSUBJECT_BINDING);
            protocolMarshaller.marshall(userPoolType.verificationMessageTemplate(), VERIFICATIONMESSAGETEMPLATE_BINDING);
            protocolMarshaller.marshall(userPoolType.smsAuthenticationMessage(), SMSAUTHENTICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall(userPoolType.mfaConfigurationAsString(), MFACONFIGURATION_BINDING);
            protocolMarshaller.marshall(userPoolType.deviceConfiguration(), DEVICECONFIGURATION_BINDING);
            protocolMarshaller.marshall(userPoolType.estimatedNumberOfUsers(), ESTIMATEDNUMBEROFUSERS_BINDING);
            protocolMarshaller.marshall(userPoolType.emailConfiguration(), EMAILCONFIGURATION_BINDING);
            protocolMarshaller.marshall(userPoolType.smsConfiguration(), SMSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(userPoolType.userPoolTags(), USERPOOLTAGS_BINDING);
            protocolMarshaller.marshall(userPoolType.smsConfigurationFailure(), SMSCONFIGURATIONFAILURE_BINDING);
            protocolMarshaller.marshall(userPoolType.emailConfigurationFailure(), EMAILCONFIGURATIONFAILURE_BINDING);
            protocolMarshaller.marshall(userPoolType.adminCreateUserConfig(), ADMINCREATEUSERCONFIG_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
