/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UserImportJobType JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UserImportJobTypeUnmarshaller implements Unmarshaller<UserImportJobType, JsonUnmarshallerContext> {

    public UserImportJobType unmarshall(JsonUnmarshallerContext context) throws Exception {
        UserImportJobType.Builder userImportJobTypeBuilder = UserImportJobType.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("JobName", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.jobName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("JobId", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.jobId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("UserPoolId", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.userPoolId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PreSignedUrl", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.preSignedUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("StartDate", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.startDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("CompletionDate", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.completionDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CloudWatchLogsRoleArn", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.cloudWatchLogsRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ImportedUsers", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.importedUsers(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("SkippedUsers", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.skippedUsers(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("FailedUsers", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.failedUsers(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("CompletionMessage", targetDepth)) {
                    context.nextToken();
                    userImportJobTypeBuilder.completionMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return userImportJobTypeBuilder.build();
    }

    private static final UserImportJobTypeUnmarshaller INSTANCE = new UserImportJobTypeUnmarshaller();

    public static UserImportJobTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
