/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SetUiCustomizationRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SetUiCustomizationRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();

    private static final MarshallingInfo<String> CSS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CSS").isBinary(false).build();

    private static final MarshallingInfo<SdkBytes> IMAGEFILE_BINDING = MarshallingInfo.builder(MarshallingType.SDK_BYTES)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageFile").isBinary(false).build();

    private static final SetUiCustomizationRequestModelMarshaller INSTANCE = new SetUiCustomizationRequestModelMarshaller();

    private SetUiCustomizationRequestModelMarshaller() {
    }

    public static SetUiCustomizationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SetUiCustomizationRequest setUiCustomizationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(setUiCustomizationRequest, "setUiCustomizationRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(setUiCustomizationRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(setUiCustomizationRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(setUiCustomizationRequest.css(), CSS_BINDING);
            protocolMarshaller.marshall(setUiCustomizationRequest.imageFile(), IMAGEFILE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
