/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PasswordPolicyType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PasswordPolicyTypeMarshaller {
    private static final MarshallingInfo<Integer> MINIMUMLENGTH_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimumLength").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIREUPPERCASE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireUppercase").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIRELOWERCASE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireLowercase").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIRENUMBERS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireNumbers").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIRESYMBOLS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireSymbols").isBinary(false).build();

    private static final PasswordPolicyTypeMarshaller INSTANCE = new PasswordPolicyTypeMarshaller();

    private PasswordPolicyTypeMarshaller() {
    }

    public static PasswordPolicyTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PasswordPolicyType passwordPolicyType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(passwordPolicyType, "passwordPolicyType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(passwordPolicyType.minimumLength(), MINIMUMLENGTH_BINDING);
            protocolMarshaller.marshall(passwordPolicyType.requireUppercase(), REQUIREUPPERCASE_BINDING);
            protocolMarshaller.marshall(passwordPolicyType.requireLowercase(), REQUIRELOWERCASE_BINDING);
            protocolMarshaller.marshall(passwordPolicyType.requireNumbers(), REQUIRENUMBERS_BINDING);
            protocolMarshaller.marshall(passwordPolicyType.requireSymbols(), REQUIRESYMBOLS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
