/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link NumberAttributeConstraintsType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class NumberAttributeConstraintsTypeMarshaller {
    private static final MarshallingInfo<String> MINVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinValue").isBinary(false).build();

    private static final MarshallingInfo<String> MAXVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxValue").isBinary(false).build();

    private static final NumberAttributeConstraintsTypeMarshaller INSTANCE = new NumberAttributeConstraintsTypeMarshaller();

    private NumberAttributeConstraintsTypeMarshaller() {
    }

    public static NumberAttributeConstraintsTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(NumberAttributeConstraintsType numberAttributeConstraintsType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(numberAttributeConstraintsType, "numberAttributeConstraintsType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(numberAttributeConstraintsType.minValue(), MINVALUE_BINDING);
            protocolMarshaller.marshall(numberAttributeConstraintsType.maxValue(), MAXVALUE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
