/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MessageTemplateType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MessageTemplateTypeMarshaller {
    private static final MarshallingInfo<String> SMSMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SMSMessage").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessage").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILSUBJECT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailSubject").isBinary(false).build();

    private static final MessageTemplateTypeMarshaller INSTANCE = new MessageTemplateTypeMarshaller();

    private MessageTemplateTypeMarshaller() {
    }

    public static MessageTemplateTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MessageTemplateType messageTemplateType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(messageTemplateType, "messageTemplateType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(messageTemplateType.smsMessage(), SMSMESSAGE_BINDING);
            protocolMarshaller.marshall(messageTemplateType.emailMessage(), EMAILMESSAGE_BINDING);
            protocolMarshaller.marshall(messageTemplateType.emailSubject(), EMAILSUBJECT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
