/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DomainDescriptionType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DomainDescriptionType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DomainDescriptionTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AWSAccountId").isBinary(false).build();

    private static final MarshallingInfo<String> DOMAIN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domain").isBinary(false).build();

    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").isBinary(false).build();

    private static final MarshallingInfo<String> CLOUDFRONTDISTRIBUTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudFrontDistribution").isBinary(false).build();

    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final DomainDescriptionTypeMarshaller INSTANCE = new DomainDescriptionTypeMarshaller();

    private DomainDescriptionTypeMarshaller() {
    }

    public static DomainDescriptionTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DomainDescriptionType domainDescriptionType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(domainDescriptionType, "domainDescriptionType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(domainDescriptionType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(domainDescriptionType.awsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall(domainDescriptionType.domain(), DOMAIN_BINDING);
            protocolMarshaller.marshall(domainDescriptionType.s3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall(domainDescriptionType.cloudFrontDistribution(), CLOUDFRONTDISTRIBUTION_BINDING);
            protocolMarshaller.marshall(domainDescriptionType.version(), VERSION_BINDING);
            protocolMarshaller.marshall(domainDescriptionType.statusAsString(), STATUS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
