/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AdminCreateUserRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AdminCreateUserRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();

    private static final MarshallingInfo<List> USERATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> VALIDATIONDATA_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationData").isBinary(false).build();

    private static final MarshallingInfo<String> TEMPORARYPASSWORD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemporaryPassword").isBinary(false).build();

    private static final MarshallingInfo<Boolean> FORCEALIASCREATION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForceAliasCreation").isBinary(false).build();

    private static final MarshallingInfo<String> MESSAGEACTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageAction").isBinary(false).build();

    private static final MarshallingInfo<List> DESIREDDELIVERYMEDIUMS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredDeliveryMediums").isBinary(false).build();

    private static final AdminCreateUserRequestModelMarshaller INSTANCE = new AdminCreateUserRequestModelMarshaller();

    private AdminCreateUserRequestModelMarshaller() {
    }

    public static AdminCreateUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AdminCreateUserRequest adminCreateUserRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(adminCreateUserRequest, "adminCreateUserRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(adminCreateUserRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.userAttributes(), USERATTRIBUTES_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.validationData(), VALIDATIONDATA_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.temporaryPassword(), TEMPORARYPASSWORD_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.forceAliasCreation(), FORCEALIASCREATION_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.messageActionAsString(), MESSAGEACTION_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.desiredDeliveryMediumsAsStrings(), DESIREDDELIVERYMEDIUMS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
