/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AdminCreateUserConfigType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AdminCreateUserConfigTypeMarshaller {
    private static final MarshallingInfo<Boolean> ALLOWADMINCREATEUSERONLY_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AllowAdminCreateUserOnly").isBinary(false).build();

    private static final MarshallingInfo<Integer> UNUSEDACCOUNTVALIDITYDAYS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("UnusedAccountValidityDays").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INVITEMESSAGETEMPLATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InviteMessageTemplate").isBinary(false).build();

    private static final AdminCreateUserConfigTypeMarshaller INSTANCE = new AdminCreateUserConfigTypeMarshaller();

    private AdminCreateUserConfigTypeMarshaller() {
    }

    public static AdminCreateUserConfigTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AdminCreateUserConfigType adminCreateUserConfigType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(adminCreateUserConfigType, "adminCreateUserConfigType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(adminCreateUserConfigType.allowAdminCreateUserOnly(), ALLOWADMINCREATEUSERONLY_BINDING);
            protocolMarshaller.marshall(adminCreateUserConfigType.unusedAccountValidityDays(), UNUSEDACCOUNTVALIDITYDAYS_BINDING);
            protocolMarshaller.marshall(adminCreateUserConfigType.inviteMessageTemplate(), INVITEMESSAGETEMPLATE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
