/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGroupRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateGroupRequest.Builder, UpdateGroupRequest> {
    private final String groupName;

    private final String userPoolId;

    private final String description;

    private final String roleArn;

    private final Integer precedence;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.userPoolId = builder.userPoolId;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.precedence = builder.precedence;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * A string containing the new description of the group.
     * </p>
     * 
     * @return A string containing the new description of the group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and
     * <code>cognito:preferred_role</code> claims in the token.
     * </p>
     * 
     * @return The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and
     *         <code>cognito:preferred_role</code> claims in the token.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The new precedence value for the group. For more information about this parameter, see <a
     * href="API_CreateGroup.html">CreateGroup</a>.
     * </p>
     * 
     * @return The new precedence value for the group. For more information about this parameter, see <a
     *         href="API_CreateGroup.html">CreateGroup</a>.
     */
    public Integer precedence() {
        return precedence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(precedence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(precedence(), other.precedence());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateGroupRequest").add("GroupName", groupName()).add("UserPoolId", userPoolId())
                .add("Description", description()).add("RoleArn", roleArn()).add("Precedence", precedence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Precedence":
            return Optional.ofNullable(clazz.cast(precedence()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, CopyableBuilder<Builder, UpdateGroupRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param groupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A string containing the new description of the group.
         * </p>
         * 
         * @param description
         *        A string containing the new description of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and
         * <code>cognito:preferred_role</code> claims in the token.
         * </p>
         * 
         * @param roleArn
         *        The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and
         *        <code>cognito:preferred_role</code> claims in the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The new precedence value for the group. For more information about this parameter, see <a
         * href="API_CreateGroup.html">CreateGroup</a>.
         * </p>
         * 
         * @param precedence
         *        The new precedence value for the group. For more information about this parameter, see <a
         *        href="API_CreateGroup.html">CreateGroup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precedence(Integer precedence);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String groupName;

        private String userPoolId;

        private String description;

        private String roleArn;

        private Integer precedence;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            groupName(model.groupName);
            userPoolId(model.userPoolId);
            description(model.description);
            roleArn(model.roleArn);
            precedence(model.precedence);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getPrecedence() {
            return precedence;
        }

        @Override
        public final Builder precedence(Integer precedence) {
            this.precedence = precedence;
            return this;
        }

        public final void setPrecedence(Integer precedence) {
            this.precedence = precedence;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }
    }
}
