/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StringAttributeConstraintsTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of constraints associated with an attribute of the string type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringAttributeConstraintsType implements StructuredPojo,
        ToCopyableBuilder<StringAttributeConstraintsType.Builder, StringAttributeConstraintsType> {
    private final String minLength;

    private final String maxLength;

    private StringAttributeConstraintsType(BuilderImpl builder) {
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
    }

    /**
     * <p>
     * The minimum length of an attribute value of the string type.
     * </p>
     * 
     * @return The minimum length of an attribute value of the string type.
     */
    public String minLength() {
        return minLength;
    }

    /**
     * <p>
     * The maximum length of an attribute value of the string type.
     * </p>
     * 
     * @return The maximum length of an attribute value of the string type.
     */
    public String maxLength() {
        return maxLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringAttributeConstraintsType)) {
            return false;
        }
        StringAttributeConstraintsType other = (StringAttributeConstraintsType) obj;
        return Objects.equals(minLength(), other.minLength()) && Objects.equals(maxLength(), other.maxLength());
    }

    @Override
    public String toString() {
        return ToString.builder("StringAttributeConstraintsType").add("MinLength", minLength()).add("MaxLength", maxLength())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinLength":
            return Optional.ofNullable(clazz.cast(minLength()));
        case "MaxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StringAttributeConstraintsTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StringAttributeConstraintsType> {
        /**
         * <p>
         * The minimum length of an attribute value of the string type.
         * </p>
         * 
         * @param minLength
         *        The minimum length of an attribute value of the string type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLength(String minLength);

        /**
         * <p>
         * The maximum length of an attribute value of the string type.
         * </p>
         * 
         * @param maxLength
         *        The maximum length of an attribute value of the string type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(String maxLength);
    }

    static final class BuilderImpl implements Builder {
        private String minLength;

        private String maxLength;

        private BuilderImpl() {
        }

        private BuilderImpl(StringAttributeConstraintsType model) {
            minLength(model.minLength);
            maxLength(model.maxLength);
        }

        public final String getMinLength() {
            return minLength;
        }

        @Override
        public final Builder minLength(String minLength) {
            this.minLength = minLength;
            return this;
        }

        public final void setMinLength(String minLength) {
            this.minLength = minLength;
        }

        public final String getMaxLength() {
            return maxLength;
        }

        @Override
        public final Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final void setMaxLength(String maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public StringAttributeConstraintsType build() {
            return new StringAttributeConstraintsType(this);
        }
    }
}
