/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.PasswordPolicyTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The password policy type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PasswordPolicyType implements StructuredPojo,
        ToCopyableBuilder<PasswordPolicyType.Builder, PasswordPolicyType> {
    private final Integer minimumLength;

    private final Boolean requireUppercase;

    private final Boolean requireLowercase;

    private final Boolean requireNumbers;

    private final Boolean requireSymbols;

    private PasswordPolicyType(BuilderImpl builder) {
        this.minimumLength = builder.minimumLength;
        this.requireUppercase = builder.requireUppercase;
        this.requireLowercase = builder.requireLowercase;
        this.requireNumbers = builder.requireNumbers;
        this.requireSymbols = builder.requireSymbols;
    }

    /**
     * <p>
     * The minimum length of the password policy that you have set. Cannot be less than 6.
     * </p>
     * 
     * @return The minimum length of the password policy that you have set. Cannot be less than 6.
     */
    public Integer minimumLength() {
        return minimumLength;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one uppercase
     * letter in their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         uppercase letter in their password.
     */
    public Boolean requireUppercase() {
        return requireUppercase;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one lowercase
     * letter in their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         lowercase letter in their password.
     */
    public Boolean requireLowercase() {
        return requireLowercase;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one number in
     * their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         number in their password.
     */
    public Boolean requireNumbers() {
        return requireNumbers;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one symbol in
     * their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         symbol in their password.
     */
    public Boolean requireSymbols() {
        return requireSymbols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumLength());
        hashCode = 31 * hashCode + Objects.hashCode(requireUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(requireLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(requireSymbols());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordPolicyType)) {
            return false;
        }
        PasswordPolicyType other = (PasswordPolicyType) obj;
        return Objects.equals(minimumLength(), other.minimumLength())
                && Objects.equals(requireUppercase(), other.requireUppercase())
                && Objects.equals(requireLowercase(), other.requireLowercase())
                && Objects.equals(requireNumbers(), other.requireNumbers())
                && Objects.equals(requireSymbols(), other.requireSymbols());
    }

    @Override
    public String toString() {
        return ToString.builder("PasswordPolicyType").add("MinimumLength", minimumLength())
                .add("RequireUppercase", requireUppercase()).add("RequireLowercase", requireLowercase())
                .add("RequireNumbers", requireNumbers()).add("RequireSymbols", requireSymbols()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumLength":
            return Optional.ofNullable(clazz.cast(minimumLength()));
        case "RequireUppercase":
            return Optional.ofNullable(clazz.cast(requireUppercase()));
        case "RequireLowercase":
            return Optional.ofNullable(clazz.cast(requireLowercase()));
        case "RequireNumbers":
            return Optional.ofNullable(clazz.cast(requireNumbers()));
        case "RequireSymbols":
            return Optional.ofNullable(clazz.cast(requireSymbols()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PasswordPolicyTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PasswordPolicyType> {
        /**
         * <p>
         * The minimum length of the password policy that you have set. Cannot be less than 6.
         * </p>
         * 
         * @param minimumLength
         *        The minimum length of the password policy that you have set. Cannot be less than 6.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLength(Integer minimumLength);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * uppercase letter in their password.
         * </p>
         * 
         * @param requireUppercase
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one uppercase letter in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireUppercase(Boolean requireUppercase);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * lowercase letter in their password.
         * </p>
         * 
         * @param requireLowercase
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one lowercase letter in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireLowercase(Boolean requireLowercase);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * number in their password.
         * </p>
         * 
         * @param requireNumbers
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one number in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireNumbers(Boolean requireNumbers);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * symbol in their password.
         * </p>
         * 
         * @param requireSymbols
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one symbol in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireSymbols(Boolean requireSymbols);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumLength;

        private Boolean requireUppercase;

        private Boolean requireLowercase;

        private Boolean requireNumbers;

        private Boolean requireSymbols;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordPolicyType model) {
            minimumLength(model.minimumLength);
            requireUppercase(model.requireUppercase);
            requireLowercase(model.requireLowercase);
            requireNumbers(model.requireNumbers);
            requireSymbols(model.requireSymbols);
        }

        public final Integer getMinimumLength() {
            return minimumLength;
        }

        @Override
        public final Builder minimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public final void setMinimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
        }

        public final Boolean getRequireUppercase() {
            return requireUppercase;
        }

        @Override
        public final Builder requireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        public final void setRequireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
        }

        public final Boolean getRequireLowercase() {
            return requireLowercase;
        }

        @Override
        public final Builder requireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        public final void setRequireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
        }

        public final Boolean getRequireNumbers() {
            return requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        public final Boolean getRequireSymbols() {
            return requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        @Override
        public PasswordPolicyType build() {
            return new PasswordPolicyType(this);
        }
    }
}
