/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.MFAOptionTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the different settings for multi-factor authentication (MFA).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MFAOptionType implements StructuredPojo, ToCopyableBuilder<MFAOptionType.Builder, MFAOptionType> {
    private final String deliveryMedium;

    private final String attributeName;

    private MFAOptionType(BuilderImpl builder) {
        this.deliveryMedium = builder.deliveryMedium;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * The delivery medium (email message or SMS message) to send the MFA code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMedium}
     * will return {@link DeliveryMediumType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryMediumAsString}.
     * </p>
     * 
     * @return The delivery medium (email message or SMS message) to send the MFA code.
     * @see DeliveryMediumType
     */
    public DeliveryMediumType deliveryMedium() {
        return DeliveryMediumType.fromValue(deliveryMedium);
    }

    /**
     * <p>
     * The delivery medium (email message or SMS message) to send the MFA code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMedium}
     * will return {@link DeliveryMediumType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryMediumAsString}.
     * </p>
     * 
     * @return The delivery medium (email message or SMS message) to send the MFA code.
     * @see DeliveryMediumType
     */
    public String deliveryMediumAsString() {
        return deliveryMedium;
    }

    /**
     * <p>
     * The attribute name of the MFA option type.
     * </p>
     * 
     * @return The attribute name of the MFA option type.
     */
    public String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryMediumAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MFAOptionType)) {
            return false;
        }
        MFAOptionType other = (MFAOptionType) obj;
        return Objects.equals(deliveryMediumAsString(), other.deliveryMediumAsString())
                && Objects.equals(attributeName(), other.attributeName());
    }

    @Override
    public String toString() {
        return ToString.builder("MFAOptionType").add("DeliveryMedium", deliveryMediumAsString())
                .add("AttributeName", attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryMedium":
            return Optional.ofNullable(clazz.cast(deliveryMediumAsString()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MFAOptionTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MFAOptionType> {
        /**
         * <p>
         * The delivery medium (email message or SMS message) to send the MFA code.
         * </p>
         * 
         * @param deliveryMedium
         *        The delivery medium (email message or SMS message) to send the MFA code.
         * @see DeliveryMediumType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryMediumType
         */
        Builder deliveryMedium(String deliveryMedium);

        /**
         * <p>
         * The delivery medium (email message or SMS message) to send the MFA code.
         * </p>
         * 
         * @param deliveryMedium
         *        The delivery medium (email message or SMS message) to send the MFA code.
         * @see DeliveryMediumType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryMediumType
         */
        Builder deliveryMedium(DeliveryMediumType deliveryMedium);

        /**
         * <p>
         * The attribute name of the MFA option type.
         * </p>
         * 
         * @param attributeName
         *        The attribute name of the MFA option type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryMedium;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(MFAOptionType model) {
            deliveryMedium(model.deliveryMedium);
            attributeName(model.attributeName);
        }

        public final String getDeliveryMedium() {
            return deliveryMedium;
        }

        @Override
        public final Builder deliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
            return this;
        }

        @Override
        public final Builder deliveryMedium(DeliveryMediumType deliveryMedium) {
            this.deliveryMedium(deliveryMedium.toString());
            return this;
        }

        public final void setDeliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public MFAOptionType build() {
            return new MFAOptionType(this);
        }
    }
}
