/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to get the header information for the .csv file for the user import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCsvHeaderRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<GetCsvHeaderRequest.Builder, GetCsvHeaderRequest> {
    private final String userPoolId;

    private GetCsvHeaderRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
    }

    /**
     * <p>
     * The user pool ID for the user pool that the users are to be imported into.
     * </p>
     * 
     * @return The user pool ID for the user pool that the users are to be imported into.
     */
    public String userPoolId() {
        return userPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCsvHeaderRequest)) {
            return false;
        }
        GetCsvHeaderRequest other = (GetCsvHeaderRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetCsvHeaderRequest").add("UserPoolId", userPoolId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, CopyableBuilder<Builder, GetCsvHeaderRequest> {
        /**
         * <p>
         * The user pool ID for the user pool that the users are to be imported into.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool that the users are to be imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCsvHeaderRequest model) {
            super(model);
            userPoolId(model.userPoolId);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCsvHeaderRequest build() {
            return new GetCsvHeaderRequest(this);
        }
    }
}
