/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DomainDescriptionTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for information about a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainDescriptionType implements StructuredPojo,
        ToCopyableBuilder<DomainDescriptionType.Builder, DomainDescriptionType> {
    private final String userPoolId;

    private final String awsAccountId;

    private final String domain;

    private final String s3Bucket;

    private final String cloudFrontDistribution;

    private final String version;

    private final String status;

    private DomainDescriptionType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsAccountId = builder.awsAccountId;
        this.domain = builder.domain;
        this.s3Bucket = builder.s3Bucket;
        this.cloudFrontDistribution = builder.cloudFrontDistribution;
        this.version = builder.version;
        this.status = builder.status;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The AWS account ID for the user pool owner.
     * </p>
     * 
     * @return The AWS account ID for the user pool owner.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The domain string.
     * </p>
     * 
     * @return The domain string.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The S3 bucket where the static files for this domain are stored.
     * </p>
     * 
     * @return The S3 bucket where the static files for this domain are stored.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The ARN of the CloudFront distribution.
     * </p>
     * 
     * @return The ARN of the CloudFront distribution.
     */
    public String cloudFrontDistribution() {
        return cloudFrontDistribution;
    }

    /**
     * <p>
     * The app version.
     * </p>
     * 
     * @return The app version.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The domain status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The domain status.
     * @see DomainStatusType
     */
    public DomainStatusType status() {
        return DomainStatusType.fromValue(status);
    }

    /**
     * <p>
     * The domain status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The domain status.
     * @see DomainStatusType
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDescriptionType)) {
            return false;
        }
        DomainDescriptionType other = (DomainDescriptionType) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(domain(), other.domain()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(cloudFrontDistribution(), other.cloudFrontDistribution())
                && Objects.equals(version(), other.version()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("DomainDescriptionType").add("UserPoolId", userPoolId()).add("AWSAccountId", awsAccountId())
                .add("Domain", domain()).add("S3Bucket", s3Bucket()).add("CloudFrontDistribution", cloudFrontDistribution())
                .add("Version", version()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "AWSAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "CloudFrontDistribution":
            return Optional.ofNullable(clazz.cast(cloudFrontDistribution()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainDescriptionTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainDescriptionType> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The AWS account ID for the user pool owner.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID for the user pool owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The domain string.
         * </p>
         * 
         * @param domain
         *        The domain string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The S3 bucket where the static files for this domain are stored.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket where the static files for this domain are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The ARN of the CloudFront distribution.
         * </p>
         * 
         * @param cloudFrontDistribution
         *        The ARN of the CloudFront distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontDistribution(String cloudFrontDistribution);

        /**
         * <p>
         * The app version.
         * </p>
         * 
         * @param version
         *        The app version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The domain status.
         * </p>
         * 
         * @param status
         *        The domain status.
         * @see DomainStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The domain status.
         * </p>
         * 
         * @param status
         *        The domain status.
         * @see DomainStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatusType
         */
        Builder status(DomainStatusType status);
    }

    static final class BuilderImpl implements Builder {
        private String userPoolId;

        private String awsAccountId;

        private String domain;

        private String s3Bucket;

        private String cloudFrontDistribution;

        private String version;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDescriptionType model) {
            userPoolId(model.userPoolId);
            awsAccountId(model.awsAccountId);
            domain(model.domain);
            s3Bucket(model.s3Bucket);
            cloudFrontDistribution(model.cloudFrontDistribution);
            version(model.version);
            status(model.status);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getAWSAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAWSAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getCloudFrontDistribution() {
            return cloudFrontDistribution;
        }

        @Override
        public final Builder cloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
            return this;
        }

        public final void setCloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DomainDescriptionType build() {
            return new DomainDescriptionType(this);
        }
    }
}
