/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeviceTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The device type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceType implements StructuredPojo, ToCopyableBuilder<DeviceType.Builder, DeviceType> {
    private final String deviceKey;

    private final List<AttributeType> deviceAttributes;

    private final Instant deviceCreateDate;

    private final Instant deviceLastModifiedDate;

    private final Instant deviceLastAuthenticatedDate;

    private DeviceType(BuilderImpl builder) {
        this.deviceKey = builder.deviceKey;
        this.deviceAttributes = builder.deviceAttributes;
        this.deviceCreateDate = builder.deviceCreateDate;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
        this.deviceLastAuthenticatedDate = builder.deviceLastAuthenticatedDate;
    }

    /**
     * <p>
     * The device key.
     * </p>
     * 
     * @return The device key.
     */
    public String deviceKey() {
        return deviceKey;
    }

    /**
     * <p>
     * The device attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The device attributes.
     */
    public List<AttributeType> deviceAttributes() {
        return deviceAttributes;
    }

    /**
     * <p>
     * The creation date of the device.
     * </p>
     * 
     * @return The creation date of the device.
     */
    public Instant deviceCreateDate() {
        return deviceCreateDate;
    }

    /**
     * <p>
     * The last modified date of the device.
     * </p>
     * 
     * @return The last modified date of the device.
     */
    public Instant deviceLastModifiedDate() {
        return deviceLastModifiedDate;
    }

    /**
     * <p>
     * The date in which the device was last authenticated.
     * </p>
     * 
     * @return The date in which the device was last authenticated.
     */
    public Instant deviceLastAuthenticatedDate() {
        return deviceLastAuthenticatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(deviceAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(deviceCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(deviceLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(deviceLastAuthenticatedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceType)) {
            return false;
        }
        DeviceType other = (DeviceType) obj;
        return Objects.equals(deviceKey(), other.deviceKey()) && Objects.equals(deviceAttributes(), other.deviceAttributes())
                && Objects.equals(deviceCreateDate(), other.deviceCreateDate())
                && Objects.equals(deviceLastModifiedDate(), other.deviceLastModifiedDate())
                && Objects.equals(deviceLastAuthenticatedDate(), other.deviceLastAuthenticatedDate());
    }

    @Override
    public String toString() {
        return ToString.builder("DeviceType").add("DeviceKey", deviceKey()).add("DeviceAttributes", deviceAttributes())
                .add("DeviceCreateDate", deviceCreateDate()).add("DeviceLastModifiedDate", deviceLastModifiedDate())
                .add("DeviceLastAuthenticatedDate", deviceLastAuthenticatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceKey":
            return Optional.ofNullable(clazz.cast(deviceKey()));
        case "DeviceAttributes":
            return Optional.ofNullable(clazz.cast(deviceAttributes()));
        case "DeviceCreateDate":
            return Optional.ofNullable(clazz.cast(deviceCreateDate()));
        case "DeviceLastModifiedDate":
            return Optional.ofNullable(clazz.cast(deviceLastModifiedDate()));
        case "DeviceLastAuthenticatedDate":
            return Optional.ofNullable(clazz.cast(deviceLastAuthenticatedDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeviceType> {
        /**
         * <p>
         * The device key.
         * </p>
         * 
         * @param deviceKey
         *        The device key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceKey(String deviceKey);

        /**
         * <p>
         * The device attributes.
         * </p>
         * 
         * @param deviceAttributes
         *        The device attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceAttributes(Collection<AttributeType> deviceAttributes);

        /**
         * <p>
         * The device attributes.
         * </p>
         * 
         * @param deviceAttributes
         *        The device attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceAttributes(AttributeType... deviceAttributes);

        /**
         * <p>
         * The device attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeType>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeType>.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceAttributes(List<AttributeType>)}.
         * 
         * @param deviceAttributes
         *        a consumer that will call methods on {@link List<AttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceAttributes(List<AttributeType>)
         */
        Builder deviceAttributes(Consumer<AttributeType.Builder>... deviceAttributes);

        /**
         * <p>
         * The creation date of the device.
         * </p>
         * 
         * @param deviceCreateDate
         *        The creation date of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCreateDate(Instant deviceCreateDate);

        /**
         * <p>
         * The last modified date of the device.
         * </p>
         * 
         * @param deviceLastModifiedDate
         *        The last modified date of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceLastModifiedDate(Instant deviceLastModifiedDate);

        /**
         * <p>
         * The date in which the device was last authenticated.
         * </p>
         * 
         * @param deviceLastAuthenticatedDate
         *        The date in which the device was last authenticated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate);
    }

    static final class BuilderImpl implements Builder {
        private String deviceKey;

        private List<AttributeType> deviceAttributes = DefaultSdkAutoConstructList.getInstance();

        private Instant deviceCreateDate;

        private Instant deviceLastModifiedDate;

        private Instant deviceLastAuthenticatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceType model) {
            deviceKey(model.deviceKey);
            deviceAttributes(model.deviceAttributes);
            deviceCreateDate(model.deviceCreateDate);
            deviceLastModifiedDate(model.deviceLastModifiedDate);
            deviceLastAuthenticatedDate(model.deviceLastAuthenticatedDate);
        }

        public final String getDeviceKey() {
            return deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final Collection<AttributeType.Builder> getDeviceAttributes() {
            return deviceAttributes != null ? deviceAttributes.stream().map(AttributeType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceAttributes(Collection<AttributeType> deviceAttributes) {
            this.deviceAttributes = AttributeListTypeCopier.copy(deviceAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceAttributes(AttributeType... deviceAttributes) {
            deviceAttributes(Arrays.asList(deviceAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceAttributes(Consumer<AttributeType.Builder>... deviceAttributes) {
            deviceAttributes(Stream.of(deviceAttributes).map(c -> AttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceAttributes(Collection<AttributeType.BuilderImpl> deviceAttributes) {
            this.deviceAttributes = AttributeListTypeCopier.copyFromBuilder(deviceAttributes);
        }

        public final Instant getDeviceCreateDate() {
            return deviceCreateDate;
        }

        @Override
        public final Builder deviceCreateDate(Instant deviceCreateDate) {
            this.deviceCreateDate = deviceCreateDate;
            return this;
        }

        public final void setDeviceCreateDate(Instant deviceCreateDate) {
            this.deviceCreateDate = deviceCreateDate;
        }

        public final Instant getDeviceLastModifiedDate() {
            return deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        public final Instant getDeviceLastAuthenticatedDate() {
            return deviceLastAuthenticatedDate;
        }

        @Override
        public final Builder deviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate) {
            this.deviceLastAuthenticatedDate = deviceLastAuthenticatedDate;
            return this;
        }

        public final void setDeviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate) {
            this.deviceLastAuthenticatedDate = deviceLastAuthenticatedDate;
        }

        @Override
        public DeviceType build() {
            return new DeviceType(this);
        }
    }
}
