/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Confirms the device response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmDeviceResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ConfirmDeviceResponse.Builder, ConfirmDeviceResponse> {
    private final Boolean userConfirmationNecessary;

    private ConfirmDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.userConfirmationNecessary = builder.userConfirmationNecessary;
    }

    /**
     * <p>
     * Indicates whether the user confirmation is necessary to confirm the device response.
     * </p>
     * 
     * @return Indicates whether the user confirmation is necessary to confirm the device response.
     */
    public Boolean userConfirmationNecessary() {
        return userConfirmationNecessary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userConfirmationNecessary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmDeviceResponse)) {
            return false;
        }
        ConfirmDeviceResponse other = (ConfirmDeviceResponse) obj;
        return Objects.equals(userConfirmationNecessary(), other.userConfirmationNecessary());
    }

    @Override
    public String toString() {
        return ToString.builder("ConfirmDeviceResponse").add("UserConfirmationNecessary", userConfirmationNecessary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserConfirmationNecessary":
            return Optional.ofNullable(clazz.cast(userConfirmationNecessary()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, CopyableBuilder<Builder, ConfirmDeviceResponse> {
        /**
         * <p>
         * Indicates whether the user confirmation is necessary to confirm the device response.
         * </p>
         * 
         * @param userConfirmationNecessary
         *        Indicates whether the user confirmation is necessary to confirm the device response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userConfirmationNecessary(Boolean userConfirmationNecessary);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private Boolean userConfirmationNecessary;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmDeviceResponse model) {
            super(model);
            userConfirmationNecessary(model.userConfirmationNecessary);
        }

        public final Boolean getUserConfirmationNecessary() {
            return userConfirmationNecessary;
        }

        @Override
        public final Builder userConfirmationNecessary(Boolean userConfirmationNecessary) {
            this.userConfirmationNecessary = userConfirmationNecessary;
            return this;
        }

        public final void setUserConfirmationNecessary(Boolean userConfirmationNecessary) {
            this.userConfirmationNecessary = userConfirmationNecessary;
        }

        @Override
        public ConfirmDeviceResponse build() {
            return new ConfirmDeviceResponse(this);
        }
    }
}
