/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminDisableProviderForUserRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminDisableProviderForUserRequest.Builder, AdminDisableProviderForUserRequest> {
    private final String userPoolId;

    private final ProviderUserIdentifierType user;

    private AdminDisableProviderForUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.user = builder.user;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The user to be disabled.
     * </p>
     * 
     * @return The user to be disabled.
     */
    public ProviderUserIdentifierType user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminDisableProviderForUserRequest)) {
            return false;
        }
        AdminDisableProviderForUserRequest other = (AdminDisableProviderForUserRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(user(), other.user());
    }

    @Override
    public String toString() {
        return ToString.builder("AdminDisableProviderForUserRequest").add("UserPoolId", userPoolId()).add("User", user()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder,
            CopyableBuilder<Builder, AdminDisableProviderForUserRequest> {
        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The user to be disabled.
         * </p>
         * 
         * @param user
         *        The user to be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(ProviderUserIdentifierType user);

        /**
         * <p>
         * The user to be disabled.
         * </p>
         * This is a convenience that creates an instance of the {@link ProviderUserIdentifierType.Builder} avoiding the
         * need to create one manually via {@link ProviderUserIdentifierType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProviderUserIdentifierType.Builder#build()} is called immediately
         * and its result is passed to {@link #user(ProviderUserIdentifierType)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link ProviderUserIdentifierType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(ProviderUserIdentifierType)
         */
        default Builder user(Consumer<ProviderUserIdentifierType.Builder> user) {
            return user(ProviderUserIdentifierType.builder().applyMutation(user).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private ProviderUserIdentifierType user;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminDisableProviderForUserRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            user(model.user);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final ProviderUserIdentifierType.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        @Override
        public final Builder user(ProviderUserIdentifierType user) {
            this.user = user;
            return this;
        }

        public final void setUser(ProviderUserIdentifierType.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminDisableProviderForUserRequest build() {
            return new AdminDisableProviderForUserRequest(this);
        }
    }
}
