/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserConfigTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of configuration for creating a new user profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminCreateUserConfigType implements StructuredPojo,
        ToCopyableBuilder<AdminCreateUserConfigType.Builder, AdminCreateUserConfigType> {
    private final Boolean allowAdminCreateUserOnly;

    private final Integer unusedAccountValidityDays;

    private final MessageTemplateType inviteMessageTemplate;

    private AdminCreateUserConfigType(BuilderImpl builder) {
        this.allowAdminCreateUserOnly = builder.allowAdminCreateUserOnly;
        this.unusedAccountValidityDays = builder.unusedAccountValidityDays;
        this.inviteMessageTemplate = builder.inviteMessageTemplate;
    }

    /**
     * <p>
     * Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code>
     * if users can sign themselves up via an app.
     * </p>
     * 
     * @return Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to
     *         <code>False</code> if users can sign themselves up via an app.
     */
    public Boolean allowAdminCreateUserOnly() {
        return allowAdminCreateUserOnly;
    }

    /**
     * <p>
     * The user account expiration limit, in days, after which the account is no longer usable. To reset the account
     * after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the
     * <code>MessageAction</code> parameter. The default value for this parameter is 7.
     * </p>
     * 
     * @return The user account expiration limit, in days, after which the account is no longer usable. To reset the
     *         account after that time limit, you must call <code>AdminCreateUser</code> again, specifying
     *         <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter
     *         is 7.
     */
    public Integer unusedAccountValidityDays() {
        return unusedAccountValidityDays;
    }

    /**
     * <p>
     * The message template to be used for the welcome message to new users.
     * </p>
     * 
     * @return The message template to be used for the welcome message to new users.
     */
    public MessageTemplateType inviteMessageTemplate() {
        return inviteMessageTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowAdminCreateUserOnly());
        hashCode = 31 * hashCode + Objects.hashCode(unusedAccountValidityDays());
        hashCode = 31 * hashCode + Objects.hashCode(inviteMessageTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserConfigType)) {
            return false;
        }
        AdminCreateUserConfigType other = (AdminCreateUserConfigType) obj;
        return Objects.equals(allowAdminCreateUserOnly(), other.allowAdminCreateUserOnly())
                && Objects.equals(unusedAccountValidityDays(), other.unusedAccountValidityDays())
                && Objects.equals(inviteMessageTemplate(), other.inviteMessageTemplate());
    }

    @Override
    public String toString() {
        return ToString.builder("AdminCreateUserConfigType").add("AllowAdminCreateUserOnly", allowAdminCreateUserOnly())
                .add("UnusedAccountValidityDays", unusedAccountValidityDays())
                .add("InviteMessageTemplate", inviteMessageTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowAdminCreateUserOnly":
            return Optional.ofNullable(clazz.cast(allowAdminCreateUserOnly()));
        case "UnusedAccountValidityDays":
            return Optional.ofNullable(clazz.cast(unusedAccountValidityDays()));
        case "InviteMessageTemplate":
            return Optional.ofNullable(clazz.cast(inviteMessageTemplate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdminCreateUserConfigTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AdminCreateUserConfigType> {
        /**
         * <p>
         * Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to
         * <code>False</code> if users can sign themselves up via an app.
         * </p>
         * 
         * @param allowAdminCreateUserOnly
         *        Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to
         *        <code>False</code> if users can sign themselves up via an app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly);

        /**
         * <p>
         * The user account expiration limit, in days, after which the account is no longer usable. To reset the account
         * after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for
         * the <code>MessageAction</code> parameter. The default value for this parameter is 7.
         * </p>
         * 
         * @param unusedAccountValidityDays
         *        The user account expiration limit, in days, after which the account is no longer usable. To reset the
         *        account after that time limit, you must call <code>AdminCreateUser</code> again, specifying
         *        <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this
         *        parameter is 7.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccountValidityDays(Integer unusedAccountValidityDays);

        /**
         * <p>
         * The message template to be used for the welcome message to new users.
         * </p>
         * 
         * @param inviteMessageTemplate
         *        The message template to be used for the welcome message to new users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inviteMessageTemplate(MessageTemplateType inviteMessageTemplate);

        /**
         * <p>
         * The message template to be used for the welcome message to new users.
         * </p>
         * This is a convenience that creates an instance of the {@link MessageTemplateType.Builder} avoiding the need
         * to create one manually via {@link MessageTemplateType#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageTemplateType.Builder#build()} is called immediately and
         * its result is passed to {@link #inviteMessageTemplate(MessageTemplateType)}.
         * 
         * @param inviteMessageTemplate
         *        a consumer that will call methods on {@link MessageTemplateType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inviteMessageTemplate(MessageTemplateType)
         */
        default Builder inviteMessageTemplate(Consumer<MessageTemplateType.Builder> inviteMessageTemplate) {
            return inviteMessageTemplate(MessageTemplateType.builder().applyMutation(inviteMessageTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowAdminCreateUserOnly;

        private Integer unusedAccountValidityDays;

        private MessageTemplateType inviteMessageTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminCreateUserConfigType model) {
            allowAdminCreateUserOnly(model.allowAdminCreateUserOnly);
            unusedAccountValidityDays(model.unusedAccountValidityDays);
            inviteMessageTemplate(model.inviteMessageTemplate);
        }

        public final Boolean getAllowAdminCreateUserOnly() {
            return allowAdminCreateUserOnly;
        }

        @Override
        public final Builder allowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly) {
            this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
            return this;
        }

        public final void setAllowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly) {
            this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
        }

        public final Integer getUnusedAccountValidityDays() {
            return unusedAccountValidityDays;
        }

        @Override
        public final Builder unusedAccountValidityDays(Integer unusedAccountValidityDays) {
            this.unusedAccountValidityDays = unusedAccountValidityDays;
            return this;
        }

        public final void setUnusedAccountValidityDays(Integer unusedAccountValidityDays) {
            this.unusedAccountValidityDays = unusedAccountValidityDays;
        }

        public final MessageTemplateType.Builder getInviteMessageTemplate() {
            return inviteMessageTemplate != null ? inviteMessageTemplate.toBuilder() : null;
        }

        @Override
        public final Builder inviteMessageTemplate(MessageTemplateType inviteMessageTemplate) {
            this.inviteMessageTemplate = inviteMessageTemplate;
            return this;
        }

        public final void setInviteMessageTemplate(MessageTemplateType.BuilderImpl inviteMessageTemplate) {
            this.inviteMessageTemplate = inviteMessageTemplate != null ? inviteMessageTemplate.build() : null;
        }

        @Override
        public AdminCreateUserConfigType build() {
            return new AdminCreateUserConfigType(this);
        }
    }
}
