/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to add custom attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddCustomAttributesRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AddCustomAttributesRequest.Builder, AddCustomAttributesRequest> {
    private final String userPoolId;

    private final List<SchemaAttributeType> customAttributes;

    private AddCustomAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.customAttributes = builder.customAttributes;
    }

    /**
     * <p>
     * The user pool ID for the user pool where you want to add custom attributes.
     * </p>
     * 
     * @return The user pool ID for the user pool where you want to add custom attributes.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * An array of custom attributes, such as Mutable and Name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of custom attributes, such as Mutable and Name.
     */
    public List<SchemaAttributeType> customAttributes() {
        return customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(customAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCustomAttributesRequest)) {
            return false;
        }
        AddCustomAttributesRequest other = (AddCustomAttributesRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(customAttributes(), other.customAttributes());
    }

    @Override
    public String toString() {
        return ToString.builder("AddCustomAttributesRequest").add("UserPoolId", userPoolId())
                .add("CustomAttributes", customAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "CustomAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, CopyableBuilder<Builder, AddCustomAttributesRequest> {
        /**
         * <p>
         * The user pool ID for the user pool where you want to add custom attributes.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool where you want to add custom attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * An array of custom attributes, such as Mutable and Name.
         * </p>
         * 
         * @param customAttributes
         *        An array of custom attributes, such as Mutable and Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(Collection<SchemaAttributeType> customAttributes);

        /**
         * <p>
         * An array of custom attributes, such as Mutable and Name.
         * </p>
         * 
         * @param customAttributes
         *        An array of custom attributes, such as Mutable and Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(SchemaAttributeType... customAttributes);

        /**
         * <p>
         * An array of custom attributes, such as Mutable and Name.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaAttributeType>.Builder} avoiding the
         * need to create one manually via {@link List<SchemaAttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaAttributeType>.Builder#build()} is called immediately
         * and its result is passed to {@link #customAttributes(List<SchemaAttributeType>)}.
         * 
         * @param customAttributes
         *        a consumer that will call methods on {@link List<SchemaAttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAttributes(List<SchemaAttributeType>)
         */
        Builder customAttributes(Consumer<SchemaAttributeType.Builder>... customAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private List<SchemaAttributeType> customAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddCustomAttributesRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            customAttributes(model.customAttributes);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final Collection<SchemaAttributeType.Builder> getCustomAttributes() {
            return customAttributes != null ? customAttributes.stream().map(SchemaAttributeType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customAttributes(Collection<SchemaAttributeType> customAttributes) {
            this.customAttributes = CustomAttributesListTypeCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(SchemaAttributeType... customAttributes) {
            customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<SchemaAttributeType.Builder>... customAttributes) {
            customAttributes(Stream.of(customAttributes).map(c -> SchemaAttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomAttributes(Collection<SchemaAttributeType.BuilderImpl> customAttributes) {
            this.customAttributes = CustomAttributesListTypeCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddCustomAttributesRequest build() {
            return new AddCustomAttributesRequest(this);
        }
    }
}
